/////////////////////////////////////////////////////////////
// CINEMA 4D SDK                                           //
/////////////////////////////////////////////////////////////
// (c) 1989-2011 MAXON Computer GmbH, all rights reserved  //
/////////////////////////////////////////////////////////////

// This is the main file of the CINEMA 4D SDK
//
// When you create your own projects much less code is needed (this file is rather long as it tries to show all kinds of different uses).
//
// An empty project simply looks like this:
//
// #include "c4d.h"
//
// Bool PluginStart(void)
// {
//   ...do or register something...
//   return TRUE;
// }
//
// void PluginEnd(void)
// {
// }
//
// Bool PluginMessage(LONG id, void *data)
// {
//   return FALSE;
// }
//


#include "c4d.h"
#include <string.h>

// forward declarations
Bool RegisterSN();
Bool RegisterGradient(void);
Bool RegisterBitmap(void);
Bool RegisterMandelbrot(void);
Bool RegisterSimpleMaterial(void);
Bool RegisterParticleVolume(void);
Bool RegisterMenuTest(void);
Bool RegisterAsyncTest(void);
Bool RegisterActiveObjectDlg();
Bool RegisterListView(void);
Bool RegisterSubDialog(void);
Bool RegisterSpherify(void);
Bool RegisterRoundedTube(void);
Bool RegisterTriangulate(void);
Bool RegisterVPTest(void);
Bool RegisterVPInvertImage(void);
Bool RegisterBlinker(void);
Bool RegisterAtomObject(void);
Bool RegisterCircle(void);
Bool RegisterGLTestObject(void);
Bool RegisterGLTestMaterial(void);
void FreeGLTestObject();
Bool RegisterSTL(void);
Bool RegisterSculpt(void);
Bool RegisterBFF(void);
Bool RegisterLookAtCamera(void);
Bool RegisterGravitation(void);
Bool RegisterThreshold(void);
Bool RegisterSampleMatrix(void);
Bool RegisterPrimitiveTool(void);
Bool RegisterMorphMixer(void);
Bool RegisterVPVisualizeNormals(void);
Bool RegisterVPVisualizeChannel(void);
Bool RegisterVPReconstruct(void);
Bool RegisterExampleDataType(void);
Bool RegisterMemoryStat(void);
Bool RegisterEdgeCutTool();
Bool RegisterPickObjectTool();
Bool RegisterReverseNormals();
Bool RegisterLayerShaderBrowser();
Bool RegisterPainterSaveTest();
Bool RegisterRandomFalloff();
Bool RegisterNoiseEffector();
Bool RegisterDropEffector();
Bool RegisterDeformerObject();
Bool RegisterForceObject();
Bool RegisterCollisionObject();
Bool RegisterConstraintObject();
Bool RegisterGrassObject();
Bool RegisterShader();
Bool RegisterVideopost();
Bool RegisterStylingTag();
Bool RegisterRenderingTag();
Bool RegisterGeneratorObject();
Bool RegisterExampleSNHook();
void FreeExampleSNHook();
Bool RegisterSculptingTool();
Bool RegisterSculptSnapTool();
Bool RegisterStereoVideoPost();
void	MiscTest();

C4D_CrashHandler old_handler;

void SDKCrashHandler(CHAR *crashinfo)
{
	//printf("SDK CrashInfo:\n");
	//printf(crashinfo);

	// don't forget to call the original handler!!!
	if (old_handler) (*old_handler)(crashinfo);
}

void EnhanceMainMenu(void)
{
	// do this only if necessary - otherwise the user will end up with dozens of menus!

	BaseContainer *bc = GetMenuResource(String("M_EDITOR"));
	if (!bc) return;

	// search for the most important menu entry. if present, the user has customized the settings
	// -> don't add menu again
	if (SearchMenuResource(bc,String("PLUGIN_CMD_1000472")))
		return;

	GeData *last = SearchPluginMenuResource();

	BaseContainer sc;
	sc.InsData(MENURESOURCE_SUBTITLE,String("SDK Test"));
	sc.InsData(MENURESOURCE_COMMAND,String("IDM_NEU")); // add C4D's new scene command to menu
	sc.InsData(MENURESOURCE_SEPERATOR,TRUE);
	sc.InsData(MENURESOURCE_COMMAND,String("PLUGIN_CMD_1000472")); // add ActiveObject dialog to menu

	if (last)
		bc->InsDataAfter(MENURESOURCE_STRING,sc,last);
	else // user killed plugin menu - add as last overall entry
		bc->InsData(MENURESOURCE_STRING,sc);
}

Bool PluginStart(void)
{
	// example of installing a crashhandler
	// remove this if you don't need it!
	//{
	//	old_handler = C4DOS.CrashHandler; // backup the original handler (must be called!)
	//	C4DOS.CrashHandler = SDKCrashHandler; // insert the own handler
	//}

	//MiscTest();

	// shader plugin examples
	if (!RegisterGradient()) return FALSE;
	if (!RegisterBitmap()) return FALSE;
	if (!RegisterMandelbrot()) return FALSE;
	if (!RegisterSimpleMaterial()) return FALSE;
	if (!RegisterParticleVolume()) return FALSE;

	// menu plugin examples
	if (!RegisterMenuTest()) return FALSE;
	if (!RegisterAsyncTest()) return FALSE;
	if (!RegisterActiveObjectDlg()) return FALSE;
	if (!RegisterListView()) return FALSE;
	if (!RegisterSubDialog()) return FALSE;
	if (!RegisterLayerShaderBrowser()) return FALSE;

	// filter plugin examples
	if (!RegisterSTL()) return FALSE;
	if (!RegisterBFF()) return FALSE;
	if (!RegisterSculpt()) return FALSE;

	// object plugin examples
	if (!RegisterSpherify()) return FALSE;
	if (!RegisterRoundedTube()) return FALSE;
	if (!RegisterGravitation()) return FALSE;
	if (!RegisterAtomObject()) return FALSE;
	if (!RegisterCircle()) return FALSE;
	if (!RegisterGLTestObject()) return FALSE;
	if (!RegisterGLTestMaterial()) return FALSE;
	if (!RegisterTriangulate()) return FALSE;
	if (!RegisterMorphMixer()) return FALSE;

	// tool plugin examples
	if (!RegisterPrimitiveTool()) return FALSE;
	if (!RegisterEdgeCutTool()) return FALSE;
	if (!RegisterPickObjectTool()) return FALSE;
	if (!RegisterReverseNormals()) return FALSE;
	if (!RegisterSculptingTool()) return FALSE;
	if (!RegisterSculptSnapTool()) return FALSE;
	// animation plugin example
	if (!RegisterBlinker()) return FALSE;

	// tag / expression plugin examples
	if (!RegisterLookAtCamera()) return FALSE;

	// bitmap filter examples
	if (!RegisterThreshold()) return FALSE;
	if (!RegisterSampleMatrix()) return FALSE;

	// video post examples
	if (!RegisterVPTest()) return FALSE;
	if (!RegisterVPInvertImage()) return FALSE;
	if (!RegisterVPVisualizeNormals()) return FALSE;
	if (!RegisterVPReconstruct()) return FALSE;
	if (!RegisterVPVisualizeChannel()) return FALSE;
	if (!RegisterStereoVideoPost()) return FALSE;

	if (!RegisterMemoryStat()) return FALSE;
	if (!RegisterPainterSaveTest()) return FALSE;

	// falloff type examples
	if (!RegisterRandomFalloff()) return FALSE;

	// effector plugin examples, can only be loaded if MoGfx is installed
	RegisterNoiseEffector();
	RegisterDropEffector();

	// hair examples
	if (!RegisterDeformerObject()) return FALSE;
	if (!RegisterForceObject()) return FALSE;
	if (!RegisterCollisionObject()) return FALSE;
	if (!RegisterConstraintObject()) return FALSE;
	if (!RegisterGrassObject()) return FALSE;
	if (!RegisterShader()) return FALSE;
	if (!RegisterVideopost()) return FALSE;
	if (!RegisterStylingTag()) return FALSE;
	if (!RegisterRenderingTag()) return FALSE;
	if (!RegisterGeneratorObject()) return FALSE;

	return TRUE;
}

void PluginEnd(void)
{
	FreeGLTestObject();
	FreeExampleSNHook();
}

Bool PluginMessage(LONG id, void *data)
{
	switch (id)
	{
		case C4DPL_INIT_SYS:
			if (!resource.Init()) return FALSE; // don't start plugin without resource

			// register example datatype. This is happening at the earliest possible time
			if (!RegisterExampleDataType()) return FALSE;

			// serial hook example; if used must be registered before PluginStart(), best in C4DPL_INIT_SYS
			//if (!RegisterExampleSNHook()) return FALSE;

			return TRUE;

		case C4DMSG_PRIORITY:
			//react to this message to set a plugin priority (to determine in which order plugins are initialized or loaded
			//SetPluginPriority(data, mypriority);
			return TRUE;

		case C4DPL_BUILDMENU:
		  //react to this message to dynamically enhance the menu
			//EnhanceMainMenu();
			break;

		case C4DPL_COMMANDLINEARGS:
		  //react to this message to react to command line arguments on startup
			/*{
				C4DPL_CommandLineArgs *args = (C4DPL_CommandLineArgs*)data;
				LONG i;

				for (i=0;i<args->argc;i++)
				{
					if (!args->argv[i]) continue;

					if (!strcmp(args->argv[i],"--help") || !strcmp(args->argv[i],"-help"))
					{
						// do not clear the entry so that other plugins can make their output!!!
						GePrint("\x01-SDK is here :-)");
					}
					else if (!strcmp(args->argv[i],"-SDK"))
					{
						args->argv[i] = NULL;
						GePrint("\x01-SDK executed:-)");
					}
					else if (!strcmp(args->argv[i],"-plugincrash"))
					{
						args->argv[i] = NULL;
						*((LONG*)0) = 1234;
					}
				}
			}*/
			break;

		case C4DPL_EDITIMAGE:
			/*{
				C4DPL_EditImage *editimage = (C4DPL_EditImage*)data;
				if (!data) break;
				if (editimage->return_processed) break;
				GePrint("C4DSDK - Edit Image Hook: "+editimage->imagefn->GetString());
				// editimage->return_processed = TRUE; if image was processed
			}*/
			return FALSE;
	}

	return FALSE;
}
